/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.items;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzacraft.blockentity.PizzaHungerSystem;
import com.tiviacz.pizzacraft.util.FoodUtils;
import com.tiviacz.pizzacraft.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

public class PizzaSliceItem
extends Item {
    public PizzaSliceItem(Item.Properties properties) {
        super(properties.m_41489_(new FoodProperties.Builder().m_38767_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        int hunger = 1;
        float saturation = PizzaHungerSystem.BASE_SATURATION.floatValue() / 7.0f;
        List<Object> effects = new ArrayList();
        if (stack.m_41783_() != null) {
            boolean bl;
            ItemStackHandler tempHandler = Utils.createHandlerFromStack(stack, 9);
            boolean bl2 = false;
            if (stack.m_41783_().m_128441_("RequiresAddition")) {
                bl = stack.m_41783_().m_128471_("RequiresAddition");
            }
            PizzaHungerSystem instance = new PizzaHungerSystem(tempHandler);
            hunger = FoodUtils.getHungerForSlice(instance.getHunger(), bl);
            saturation = (float)((double)Math.round((double)(instance.getSaturation() / 7.0f) * 100.0) / 100.0);
            effects = instance.getEffects();
        }
        tooltip.add((Component)Component.m_237110_((String)"information.pizzacraft.hunger_slice", (Object[])new Object[]{hunger}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"information.pizzacraft.saturation_slice", (Object[])new Object[]{Float.valueOf(saturation)}).m_130940_(ChatFormatting.BLUE));
        if (!effects.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"information.pizzacraft.effects").m_130940_(ChatFormatting.GOLD));
            for (Pair pair : effects) {
                tooltip.add((Component)Component.m_237115_((String)((MobEffectInstance)pair.getFirst()).m_19576_()).m_130940_(((MobEffectInstance)pair.getFirst()).m_19544_().m_19483_().m_19497_()));
            }
        }
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity) {
        if (livingEntity instanceof Player && stack.m_41783_() != null) {
            ItemStackHandler tempHandler = Utils.createHandlerFromStack(stack, 9);
            boolean requiresAddition = false;
            if (stack.m_41783_().m_128441_("RequiresAddition")) {
                requiresAddition = stack.m_41783_().m_128471_("RequiresAddition");
            }
            PizzaHungerSystem instance = new PizzaHungerSystem(tempHandler);
            Player player = (Player)livingEntity;
            player.m_36324_().m_38707_(FoodUtils.getHungerForSlice(instance.getHunger(), requiresAddition), instance.getSaturation() / 7.0f);
            for (int i = 0; i < tempHandler.getSlots(); ++i) {
                FoodProperties food;
                if (tempHandler.getStackInSlot(i).m_41619_() || !tempHandler.getStackInSlot(i).m_41614_() || (food = tempHandler.getStackInSlot(i).m_41720_().m_41473_()).m_38749_().isEmpty()) continue;
                food.m_38749_().forEach(e -> {
                    if (level.f_46441_.m_188501_() < ((Float)e.getSecond()).floatValue()) {
                        player.m_7292_((MobEffectInstance)e.getFirst());
                    }
                });
            }
        }
        return livingEntity.m_5584_(level, stack);
    }
}

